﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Malefiz
{
    class Feld
    {
        //============================//
        //Allgemeine Feldeigenschaften//
        //============================//

        public Feldposition Koordinate;

        /// <summary>
        /// In dieser Eigenschaft sollen die x- und y-Koodinate dieses Spielfeldes gespeichert werden.
        /// </summary>
        //public Feldposition Koordinate
        //{
        //    get { return koordinate; }
        //    set { koordinate = value; }
        //}

        /// <summary>
        /// Die x-Koordinate dieses Feldes.
        /// </summary>
        public int X
        {
            get { return Koordinate.X; }
            set { Koordinate.X = value; }
        }

        /// <summary>
        /// Die y-Koordinate dieses Feldes.
        /// </summary>
        public int Y
        {
            get { return Koordinate.Y; }
            set { Koordinate.Y = value; }
        }

        private Image feldbild;

        /// <summary>
        /// In dieser Eigenschaft kann man das Porträt von der Spielfigur oder Barrikade abrufen, die sich zur Zeit auf diesem Feld befindet.
        /// Um das Bild zu setzen oder zu ändern, soll dies über die boolschen Eigenschaften IstBelegt und IstBlockiert sowie über 
        /// die Eigenschaft Spielernummer geschehen. Werden diese verändert, so passen sie das Feldbild intern automatisch richtig an.
        /// </summary>
        public Image Feldbild
        {
            get { return feldbild; }
            set { feldbild = value; }
        }

        bool existiertDasFeld;

        /// <summary>
        /// Diese Eigenschaft gibt in einer boolschen Variable an, ob dieses Feld auch wirklich im Spiel belegbar ist (true), oder nicht (false). 
        /// Zur Initialisierung ist diese Eigenschaft auf false gesetzt.
        /// Da diese Eigenschaft nur einmal direkt nach der Initialisierung gesetzt werden soll, existiert hierfür extra die Methode Gott um diese 
        /// Eigenschaft für dieses bestimmte Feld auf true zu setzen.
        /// </summary>
        public bool ExistiertDasFeld
        {
            get { return existiertDasFeld; }
        }

        /// <summary>
        /// "Belebt" das Feld, in dem es die Variable existiertDasFeld auf true setzt.
        /// </summary>
        public void Gott()
        {
            this.existiertDasFeld = true;
        }
        
        //==========================================================================//
        //Diese Variablen geben Aufschluss über die aktuelle Belegung dieses Feldes.//
        //==========================================================================//

        private bool istBlockiert;

        /// <summary>
        /// Soll auf true gesetzt werden, wenn auf dem Feld aktuell eine Barrikade steht. Zur Initialisierung des Feldes steht diese 
        /// Eigenschaft auf false. Wird diese Eigenschaft auf true gesetzt, so wird das Feldbild auf das Porträt einer Barrikade 
        /// gesetzt. Wird sie auf false gesetzt, so wird das Feldbild auf das transparente Bild gesetzt.
        /// </summary>
        public bool IstBlockiert
        {
            get { return istBlockiert; }
            set 
            { 
                istBlockiert = value;

                if (istBlockiert == true)
                {
                    feldbild = pictures.Barrikade;
                }
                else
                {
                    feldbild = pictures.Transparent;
                }
            }
        }

        int barrikadennummer;

        /// <summary>
        /// Gibt die Nummer der Barrikade aus, die das Feld gerade blockiert.
        /// 0: Erste Barrikade ... 10: Elfte Barrikade
        /// Wenn die Eigenschaft IstBlockiert auf true geschaltet ist, setzt diese Eigenschaft auch automatisch das Porträt einer Barrikade 
        /// auf dieses Feld.Wird sie auf false geschaltet, wird das transparente Bild geladen.
        /// </summary>
        public int Barrikadennummer
        {
            get { return barrikadennummer; }
            set { barrikadennummer = value; }
        }



        private bool istBelegt;

        /// <summary>
        /// Soll auf true gesetzt werden, wenn das Feld aktuell von einer Spielfigur besetzt ist. Zur Initialisierung des Feldes steht 
        /// diese Eigenschaft auf false. Wird diese Eigenschaft auf true gesetzt, so wird das Feldbild auf das Porträt der belegenden 
        /// Spielfigur gesetzt. Wird sie auf false gesetzt, so wird das Feldbild auf das transparente Bild gesetzt.
        /// </summary>
        public bool IstBelegt
        {
            get { return istBelegt; }
            set 
            {
                istBelegt = value;

                if (istBelegt == true)
                {
                    if (Spielernummer == 0)
                    { this.feldbild = pictures.Figur_rot; }
                    if (Spielernummer == 1)
                    { this.feldbild = pictures.Figur_grün; }
                    if (Spielernummer == 2)
                    { this.feldbild = pictures.Figur_gelb; }
                    if (Spielernummer == 3)
                    { this.feldbild = pictures.Figur_blau; }
                }

                if (istBelegt == false)
                {
                    this.feldbild = pictures.Transparent;
                }
            }
        }

        public Figurennummerierung AktuelleBelegung;

        /// <summary>
        /// In dieser Eigenschaft sollen die Spielernummer und die Figurennummer der Figur gespeichert werden, die aktuell dieses Feld belegt.
        /// </summary>
        //public Figurennummerierung AktuelleBelegung
        //{
        //    get { return aktuelleBelegung; }
        //    set { aktuelleBelegung = value; }
        //}

        /// <summary>
        /// Gibt die Nummer des Spielers an, dessen Figur dieses Feld gerade belegt.
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler
        /// Wenn die boolsche Eigenschaft IstBelegt dieses Feldes auf true gesetzt ist, setzt diese Eigenschaft auch automatich das richtige 
        /// Porträt der Spielfigur dieses Spielers auf dieses Feld. Wird sie auf fasle gesetzt, wird das transparente Bild geladen.
        /// </summary>
        public int Spielernummer
        {
            get { return AktuelleBelegung.SpielerNummer; }
            set { AktuelleBelegung.SpielerNummer = value; }
        }

        /// <summary>
        /// Gibt die Nummer der Figur an, die dieses Feld gerade belegt.
        /// 0: Erste Spielfigur ... 4: Fünfte Spielfigur
        /// </summary>
        public int Figurnummer
        {
            get { return AktuelleBelegung.FigurenNummer; }
            set { AktuelleBelegung.FigurenNummer = value; }
        }

        

        //=============//
        //Konstruktoren//
        //=============//

        public Feld()
        {
            IstBelegt = false;
            IstBlockiert = false;
            existiertDasFeld = false;
        }

        /// <summary>
        /// Erstellt ein Spielfeld mit den x- und y-Koordinaten.
        /// Voreinstellungen: 
        /// IstBelegt = false
        /// IstBlockiert = false
        /// ExistiertDasFeld = false
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        public Feld(int x, int y) : this()
        {
            Koordinate.X = x;
            Koordinate.Y = y;
        }



        //========//
        //Methoden//
        //========//

        /// <summary>
        /// Diese Methode soll aufgerufen werden, wenn eine Figur dieses Feld belegen soll.
        /// </summary>
        /// <param name="figur">Welche Figur belegt dieses Feld?</param>
        public void WirdBelegt(Figur figur)
        {
            this.Figurnummer = figur.Figurennummer;
            this.Spielernummer = figur.Spielernummer;
            this.IstBelegt = true;
        }

        /// <summary>
        /// Diese Methode soll aufgerufen werden, wenn eine Barrikade dieses Feld blockieren soll.
        /// </summary>
        /// <param name="barrikade">Welche Barrikade soll dieses Feld blockieren?</param>
        public void WirdBlockiert(Barrikade barrikade)
        {
            this.Barrikadennummer = barrikade.Barrikadennummer;
            this.IstBlockiert = true;
        }

        public void Nachjustieren(int x, int y)
        {
            Koordinate.X = x;
            Koordinate.Y = y;
        }
    }
}